package gov.va.genisis2.util;

import java.io.FileOutputStream;
import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dao.IAttachmentDAO;
import gov.va.genisis2.exceptions.GenisisDAOException;

@Component
public class ArrayOfBytesToFile {

	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(ArrayOfBytesToFile.class);

	private static final String UPLOAD_FOLDER = "C:\\temp\\";

	@Autowired
	private IAttachmentDAO attachmentDAO;

	public void bytesToFile() {

		if (LOGGER.isInfoEnabled()) {
			LOGGER.info("Convert bytes Array To File");
		}

		try {
			byte[] bFile = attachmentDAO.getAttachmentByRequestId(1).get(0).getFileData();

			// convert bytes[] into a file
			writeBytesToFile(bFile, UPLOAD_FOLDER + "test11.docx");

		} catch (GenisisDAOException e) {
			LOGGER.info(e.getMessage());
		}

	}

	private static void writeBytesToFile(byte[] bFile, String fileDest) {

		if (LOGGER.isInfoEnabled()) {
			LOGGER.info("Write Bytes Array To File");
		}

		try (FileOutputStream fileOuputStream = new FileOutputStream(fileDest)) {
			fileOuputStream.write(bFile);
		} catch (IOException e) {
			LOGGER.info(e.getMessage());
		}

	}
}